<?php
/**
 * En Bombas – AI Image Optimizer Uninstall
 *
 * Fired when the plugin is uninstalled.
 *
 * @package EnBombas
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
$options_to_delete = [
    'enbombas_settings',
    'enbombas_stats',
    'enbombas_custom_folders',
    'enbombas_monitoring_data',
    'enbombas_bulk_queue',
    'enbombas_version',
];

foreach ($options_to_delete as $option) {
    delete_option($option);
}

// Delete post meta
global $wpdb;
$wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE '_enbombas_%'");

// Delete transients
$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_enbombas_%'");
$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_timeout_enbombas_%'");

// Clear scheduled hooks
wp_clear_scheduled_hook('enbombas_cron_optimize');
wp_clear_scheduled_hook('enbombas_cron_monitoring');



