<?php
/**
 * Settings Template
 *
 * @package EnBombas
 */

if (!defined('ABSPATH')) {
    exit;
}

// SVG Icons
$icons = [
    'settings' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="3"/><path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"/></svg>',
    'sliders' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="4" y1="21" x2="4" y2="14"/><line x1="4" y1="10" x2="4" y2="3"/><line x1="12" y1="21" x2="12" y2="12"/><line x1="12" y1="8" x2="12" y2="3"/><line x1="20" y1="21" x2="20" y2="16"/><line x1="20" y1="12" x2="20" y2="3"/><line x1="1" y1="14" x2="7" y2="14"/><line x1="9" y1="8" x2="15" y2="8"/><line x1="17" y1="16" x2="23" y2="16"/></svg>',
    'bolt' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"/></svg>',
    'maximize' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M8 3H5a2 2 0 0 0-2 2v3m18 0V5a2 2 0 0 0-2-2h-3m0 18h3a2 2 0 0 0 2-2v-3M3 16v3a2 2 0 0 0 2 2h3"/></svg>',
    'palette' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="13.5" cy="6.5" r=".5"/><circle cx="17.5" cy="10.5" r=".5"/><circle cx="8.5" cy="7.5" r=".5"/><circle cx="6.5" cy="12.5" r=".5"/><path d="M12 2C6.5 2 2 6.5 2 12s4.5 10 10 10c.926 0 1.648-.746 1.648-1.688 0-.437-.18-.835-.437-1.125-.29-.289-.438-.652-.438-1.125a1.64 1.64 0 0 1 1.668-1.668h1.996c3.051 0 5.555-2.503 5.555-5.555C21.965 6.012 17.461 2 12 2z"/></svg>',
    'save' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/><polyline points="17 21 17 13 7 13 7 21"/><polyline points="7 3 7 8 15 8"/></svg>',
    'cpu' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="4" y="4" width="16" height="16" rx="2" ry="2"/><rect x="9" y="9" width="6" height="6"/><line x1="9" y1="1" x2="9" y2="4"/><line x1="15" y1="1" x2="15" y2="4"/><line x1="9" y1="20" x2="9" y2="23"/><line x1="15" y1="20" x2="15" y2="23"/><line x1="20" y1="9" x2="23" y2="9"/><line x1="20" y1="14" x2="23" y2="14"/><line x1="1" y1="9" x2="4" y2="9"/><line x1="1" y1="14" x2="4" y2="14"/></svg>',
    'rocket' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M4.5 16.5c-1.5 1.26-2 5-2 5s3.74-.5 5-2c.71-.84.7-2.13-.09-2.91a2.18 2.18 0 0 0-2.91-.09z"/><path d="m12 15-3-3a22 22 0 0 1 2-3.95A12.88 12.88 0 0 1 22 2c0 2.72-.78 7.5-6 11a22.35 22.35 0 0 1-4 2z"/><path d="M9 12H4s.55-3.03 2-4c1.62-1.08 5 0 5 0"/><path d="M12 15v5s3.03-.55 4-2c1.08-1.62 0-5 0-5"/></svg>',
    'circle-check' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10" stroke="currentColor"/></svg>',
];
?>

<div class="enbombas-wrapper">
<div class="enbombas-admin-wrap">
    <!-- Header -->
    <div class="enbombas-header">
        <div class="enbombas-header-content">
            <div class="enbombas-logo">
                <div class="enb-logo-icon">
                    <span class="enb-icon"><?php echo $icons['settings']; ?></span>
                </div>
                <div>
                    <h1><?php _e('Configuración', 'en-bombas'); ?></h1>
                    <div class="enbombas-logo-subtitle"><?php _e('Configura tus preferencias de optimización', 'en-bombas'); ?></div>
                </div>
            </div>
        </div>
    </div>

    <form id="enbombas-settings-form" method="post">
        <!-- Compression Settings -->
        <div class="enbombas-card">
            <div class="enbombas-card-header">
                <h3 class="enbombas-card-title">
                    <span class="enb-icon"><?php echo $icons['sliders']; ?></span>
                    <?php _e('Configuración de Compresión', 'en-bombas'); ?>
                </h3>
            </div>

            <div class="enbombas-settings-section">
                <h4 class="enbombas-section-title">
                    <span class="enb-icon"><?php echo $icons['bolt']; ?></span>
                    <?php _e('Nivel de Compresión', 'en-bombas'); ?>
                </h4>

                <div class="enbombas-radio-cards">
                    <label class="enbombas-radio-card <?php echo $settings['compression_level'] === 'normal' ? 'selected' : ''; ?>">
                        <input type="radio" name="compression_level" value="normal" <?php checked($settings['compression_level'], 'normal'); ?>>
                        <div class="enbombas-radio-card-icon"><span class="enb-icon enb-icon-lg" style="color: #10b981;"><?php echo $icons['circle-check']; ?></span></div>
                        <div class="enbombas-radio-card-title"><?php _e('Normal', 'en-bombas'); ?></div>
                        <div class="enbombas-radio-card-desc"><?php _e('Calidad y tamaño balanceados', 'en-bombas'); ?></div>
                    </label>

                    <label class="enbombas-radio-card <?php echo $settings['compression_level'] === 'high' ? 'selected' : ''; ?>">
                        <input type="radio" name="compression_level" value="high" <?php checked($settings['compression_level'], 'high'); ?>>
                        <div class="enbombas-radio-card-icon"><span class="enb-icon enb-icon-lg" style="color: #f59e0b;"><?php echo $icons['circle-check']; ?></span></div>
                        <div class="enbombas-radio-card-title"><?php _e('Alto', 'en-bombas'); ?></div>
                        <div class="enbombas-radio-card-desc"><?php _e('Compresión máxima', 'en-bombas'); ?></div>
                    </label>

                    <label class="enbombas-radio-card <?php echo $settings['compression_level'] === 'ultra' ? 'selected' : ''; ?>">
                        <input type="radio" name="compression_level" value="ultra" <?php checked($settings['compression_level'], 'ultra'); ?>>
                        <div class="enbombas-radio-card-icon"><span class="enb-icon enb-icon-lg" style="color: #ef4444;"><?php echo $icons['circle-check']; ?></span></div>
                        <div class="enbombas-radio-card-title"><?php _e('Ultra', 'en-bombas'); ?></div>
                        <div class="enbombas-radio-card-desc"><?php _e('Compresión extrema', 'en-bombas'); ?></div>
                    </label>

                    <label class="enbombas-radio-card <?php echo $settings['compression_level'] === 'smart' ? 'selected' : ''; ?>">
                        <input type="radio" name="compression_level" value="smart" <?php checked($settings['compression_level'], 'smart'); ?>>
                        <div class="enbombas-radio-card-icon"><span class="enb-icon enb-icon-lg" style="color: #9D7FF5;"><?php echo $icons['cpu']; ?></span></div>
                        <div class="enbombas-radio-card-title"><?php _e('Smart Bomb', 'en-bombas'); ?></div>
                        <div class="enbombas-radio-card-desc"><?php _e('La IA elige por vos', 'en-bombas'); ?></div>
                    </label>
                </div>
            </div>

            <div class="enbombas-form-group">
                <label class="enbombas-toggle">
                    <input type="checkbox" name="auto_optimize" class="enbombas-toggle-input" <?php checked($settings['auto_optimize']); ?>>
                    <span class="enbombas-toggle-slider"></span>
                    <span class="enbombas-toggle-label"><?php _e('Auto-optimizar al subir', 'en-bombas'); ?></span>
                </label>
                <p class="enbombas-form-description"><?php _e('Optimiza automáticamente las imágenes cuando se suben a la Biblioteca de Medios.', 'en-bombas'); ?></p>
            </div>

            <div class="enbombas-form-group">
                <label class="enbombas-toggle">
                    <input type="checkbox" name="remove_exif" class="enbombas-toggle-input" <?php checked($settings['remove_exif']); ?>>
                    <span class="enbombas-toggle-slider"></span>
                    <span class="enbombas-toggle-label"><?php _e('Eliminar metadatos EXIF', 'en-bombas'); ?></span>
                </label>
                <p class="enbombas-form-description"><?php _e('Quita los metadatos (info de cámara, GPS, etc.) de las imágenes para reducir tamaño y proteger la privacidad.', 'en-bombas'); ?></p>
            </div>

            <div class="enbombas-form-group">
                <label class="enbombas-toggle">
                    <input type="checkbox" name="optimize_thumbnails" class="enbombas-toggle-input" <?php checked($settings['optimize_thumbnails']); ?>>
                    <span class="enbombas-toggle-slider"></span>
                    <span class="enbombas-toggle-label"><?php _e('Optimizar miniaturas', 'en-bombas'); ?></span>
                </label>
                <p class="enbombas-form-description"><?php _e('Optimiza todos los tamaños de miniatura generados para cada imagen.', 'en-bombas'); ?></p>
            </div>
        </div>

        <!-- Resize Settings -->
        <div class="enbombas-card">
            <div class="enbombas-card-header">
                <h3 class="enbombas-card-title">
                    <span class="enb-icon"><?php echo $icons['maximize']; ?></span>
                    <?php _e('Configuración de Redimensión', 'en-bombas'); ?>
                </h3>
            </div>

            <div class="enbombas-form-group">
                <label class="enbombas-toggle">
                    <input type="checkbox" name="resize_larger" class="enbombas-toggle-input" <?php checked($settings['resize_larger']); ?>>
                    <span class="enbombas-toggle-slider"></span>
                    <span class="enbombas-toggle-label"><?php _e('Redimensionar imágenes grandes', 'en-bombas'); ?></span>
                </label>
                <p class="enbombas-form-description"><?php _e('Redimensiona automáticamente las imágenes que excedan las dimensiones máximas.', 'en-bombas'); ?></p>
            </div>

            <div class="enbombas-form-group" data-depends-on="resize_larger" style="<?php echo $settings['resize_larger'] ? '' : 'display:none;'; ?>">
                <label class="enbombas-form-label"><?php _e('Ancho Máximo', 'en-bombas'); ?></label>
                <input type="number" name="max_width" value="<?php echo esc_attr($settings['max_width']); ?>" class="enbombas-form-input" min="100" max="10000">
                <p class="enbombas-form-description"><?php _e('Ancho máximo en píxeles. Las imágenes más anchas serán redimensionadas.', 'en-bombas'); ?></p>
            </div>

            <div class="enbombas-form-group" data-depends-on="resize_larger" style="<?php echo $settings['resize_larger'] ? '' : 'display:none;'; ?>">
                <label class="enbombas-form-label"><?php _e('Alto Máximo', 'en-bombas'); ?></label>
                <input type="number" name="max_height" value="<?php echo esc_attr($settings['max_height']); ?>" class="enbombas-form-input" min="100" max="10000">
                <p class="enbombas-form-description"><?php _e('Alto máximo en píxeles. Las imágenes más altas serán redimensionadas.', 'en-bombas'); ?></p>
            </div>
        </div>

        <!-- Next-Gen Formats -->
        <div class="enbombas-card">
            <div class="enbombas-card-header">
                <h3 class="enbombas-card-title">
                    <span class="enb-icon"><?php echo $icons['palette']; ?></span>
                    <?php _e('Formatos Next-Gen', 'en-bombas'); ?>
                </h3>
            </div>

            <div class="enbombas-form-group">
                <label class="enbombas-toggle">
                    <input type="checkbox" name="generate_webp" class="enbombas-toggle-input" <?php checked($settings['generate_webp']); ?>>
                    <span class="enbombas-toggle-slider"></span>
                    <span class="enbombas-toggle-label"><?php _e('Generar versiones WebP', 'en-bombas'); ?></span>
                </label>
                <p class="enbombas-form-description"><?php _e('Crea versiones WebP de las imágenes para navegadores modernos. WebP típicamente proporciona archivos 25-35% más pequeños.', 'en-bombas'); ?></p>
            </div>

            <div class="enbombas-form-group">
                <label class="enbombas-toggle">
                    <input type="checkbox" name="generate_avif" class="enbombas-toggle-input" <?php checked($settings['generate_avif']); ?>>
                    <span class="enbombas-toggle-slider"></span>
                    <span class="enbombas-toggle-label"><?php _e('Generar versiones AVIF', 'en-bombas'); ?></span>
                </label>
                <p class="enbombas-form-description"><?php _e('Crea versiones AVIF para navegadores de última generación. AVIF proporciona mejor compresión que WebP. Requiere PHP 8.1+.', 'en-bombas'); ?></p>
            </div>

            <div class="enbombas-form-group">
                <label class="enbombas-form-label"><?php _e('Método de Entrega', 'en-bombas'); ?></label>
                <select name="nextgen_method" class="enbombas-form-select">
                    <option value="picture" <?php selected($settings['nextgen_method'], 'picture'); ?>><?php _e('Etiqueta Picture (Recomendado)', 'en-bombas'); ?></option>
                    <option value="htaccess" <?php selected($settings['nextgen_method'], 'htaccess'); ?>><?php _e('Reglas de Reescritura .htaccess', 'en-bombas'); ?></option>
                </select>
                <p class="enbombas-form-description"><?php _e('Cómo servir los formatos next-gen a los navegadores que los soportan.', 'en-bombas'); ?></p>
            </div>
        </div>

        <!-- Backup Settings -->
        <div class="enbombas-card">
            <div class="enbombas-card-header">
                <h3 class="enbombas-card-title">
                    <span class="enb-icon"><?php echo $icons['save']; ?></span>
                    <?php _e('Respaldo y Restauración', 'en-bombas'); ?>
                </h3>
            </div>

            <div class="enbombas-form-group">
                <label class="enbombas-toggle">
                    <input type="checkbox" name="backup_enabled" class="enbombas-toggle-input" <?php checked($settings['backup_enabled']); ?>>
                    <span class="enbombas-toggle-slider"></span>
                    <span class="enbombas-toggle-label"><?php _e('Guardar respaldos originales', 'en-bombas'); ?></span>
                </label>
                <p class="enbombas-form-description"><?php _e('Guarda las imágenes originales antes de optimizar para poder restaurarlas después.', 'en-bombas'); ?></p>
            </div>
        </div>

        <!-- AI Monitoring -->
        <div class="enbombas-card">
            <div class="enbombas-card-header">
                <h3 class="enbombas-card-title">
                    <span class="enb-icon"><?php echo $icons['cpu']; ?></span>
                    <?php _e('Monitoreo IA', 'en-bombas'); ?>
                </h3>
            </div>

            <div class="enbombas-form-group">
                <label class="enbombas-toggle">
                    <input type="checkbox" name="monitoring_enabled" class="enbombas-toggle-input" <?php checked($settings['monitoring_enabled']); ?>>
                    <span class="enbombas-toggle-slider"></span>
                    <span class="enbombas-toggle-label"><?php _e('Activar monitoreo IA', 'en-bombas'); ?></span>
                </label>
                <p class="enbombas-form-description"><?php _e('Detecta y te alerta automáticamente sobre imágenes sin optimizar o muy pesadas.', 'en-bombas'); ?></p>
            </div>

            <div class="enbombas-form-group" data-depends-on="monitoring_enabled" style="<?php echo $settings['monitoring_enabled'] ? '' : 'display:none;'; ?>">
                <label class="enbombas-toggle">
                    <input type="checkbox" name="alert_oversized" class="enbombas-toggle-input" <?php checked($settings['alert_oversized']); ?>>
                    <span class="enbombas-toggle-slider"></span>
                    <span class="enbombas-toggle-label"><?php _e('Alertar por imágenes muy pesadas', 'en-bombas'); ?></span>
                </label>
            </div>

            <div class="enbombas-form-group" data-depends-on="monitoring_enabled" style="<?php echo $settings['monitoring_enabled'] ? '' : 'display:none;'; ?>">
                <label class="enbombas-form-label"><?php _e('Umbral de Peso (KB)', 'en-bombas'); ?></label>
                <input type="number" name="oversized_threshold" value="<?php echo esc_attr($settings['oversized_threshold']); ?>" class="enbombas-form-input" min="50" max="5000">
                <p class="enbombas-form-description"><?php _e('Las imágenes más grandes que este tamaño serán marcadas como muy pesadas.', 'en-bombas'); ?></p>
            </div>
        </div>

        <!-- Bulk Optimization -->
        <div class="enbombas-card">
            <div class="enbombas-card-header">
                <h3 class="enbombas-card-title">
                    <span class="enb-icon"><?php echo $icons['rocket']; ?></span>
                    <?php _e('Optimización Masiva', 'en-bombas'); ?>
                </h3>
            </div>

            <div class="enbombas-form-group">
                <label class="enbombas-toggle">
                    <input type="checkbox" name="turbo_mode" class="enbombas-toggle-input" <?php checked($settings['turbo_mode']); ?>>
                    <span class="enbombas-toggle-slider"></span>
                    <span class="enbombas-toggle-label"><?php _e('Modo Turbo', 'en-bombas'); ?></span>
                </label>
                <p class="enbombas-form-description"><?php _e('Procesa más imágenes por lote para una optimización masiva más rápida. Puede aumentar la carga del servidor.', 'en-bombas'); ?></p>
            </div>
        </div>

        <!-- Save Button -->
        <div style="margin-top: 24px;">
            <button type="submit" class="enbombas-btn enbombas-btn-primary">
                <span class="enb-icon"><?php echo $icons['save']; ?></span>
                <?php _e('Guardar Configuración', 'en-bombas'); ?>
            </button>
        </div>
    </form>
</div>
</div>
