<?php
/**
 * Nitro Admin Page Template
 *
 * @package EnBombas
 */

if (!defined('ABSPATH')) {
    exit;
}

use EnBombas\Nitro\NitroCore;

$nitro = NitroCore::get_instance();
$settings = $nitro->get_settings();
$cache_stats = $nitro->get_cache_system()->get_stats();
$db_stats = $nitro->get_database()->get_stats();
?>

<div class="enbombas-wrapper">
<div class="wrap enbombas-admin-wrap enbombas-nitro-wrap">
    <!-- Header -->
    <div class="enbombas-header">
        <div class="enbombas-header-content">
            <div class="enbombas-logo-container">
                <div class="enbombas-logo-icon">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"/>
                    </svg>
                </div>
                <div class="enbombas-logo-text">
                    <h1><?php _e('En Bombas Nitro', 'en-bombas'); ?></h1>
                    <p><?php _e('Rendimiento Total para tu Sitio', 'en-bombas'); ?></p>
                </div>
            </div>
            <div class="enbombas-header-actions">
                <button type="button" id="enb-nitro-clear-cache" class="enbombas-btn enbombas-btn-secondary">
                    <span class="enb-icon enb-icon-trash"></span>
                    <?php _e('Borrar Caché', 'en-bombas'); ?>
                </button>
            </div>
        </div>
    </div>

    <!-- Stats Overview -->
    <div class="enbombas-stats-row">
        <div class="enbombas-stat-card enb-card enb-card-accent-green">
            <div class="enbombas-stat-icon enb-card-icon-bg enb-icon-cache"></div>
            <div class="enbombas-stat-content">
                <span class="enbombas-stat-value enb-card-value enb-accent-green" id="nitro-cache-files"><?php echo esc_html($cache_stats['total_files']); ?></span>
                <span class="enbombas-stat-label"><?php _e('Páginas en caché', 'en-bombas'); ?></span>
            </div>
        </div>
        <div class="enbombas-stat-card enb-card enb-card-accent-blue">
            <div class="enbombas-stat-icon enb-card-icon-bg enb-icon-storage"></div>
            <div class="enbombas-stat-content">
                <span class="enbombas-stat-value enb-card-value enb-accent-blue" id="nitro-cache-size"><?php echo esc_html($cache_stats['total_size_formatted']); ?></span>
                <span class="enbombas-stat-label"><?php _e('Tamaño del caché', 'en-bombas'); ?></span>
            </div>
        </div>
        <div class="enbombas-stat-card enb-card enb-card-accent-purple">
            <div class="enbombas-stat-icon enb-card-icon-bg enb-icon-database"></div>
            <div class="enbombas-stat-content">
                <span class="enbombas-stat-value enb-card-value enb-accent-purple" id="nitro-db-size"><?php echo esc_html($db_stats['db_size_formatted']); ?></span>
                <span class="enbombas-stat-label"><?php _e('Tamaño de la BD', 'en-bombas'); ?></span>
            </div>
        </div>
        <div class="enbombas-stat-card enb-card enb-card-accent-red">
            <div class="enbombas-stat-icon enb-card-icon-bg enb-icon-cleanup"></div>
            <div class="enbombas-stat-content">
                <span class="enbombas-stat-value enb-card-value <?php echo $db_stats['potential_savings'] > 0 ? 'enb-accent-yellow' : 'enb-accent-red'; ?>" id="nitro-db-potential"><?php echo esc_html($db_stats['potential_savings']); ?></span>
                <span class="enbombas-stat-label"><?php _e('Elementos a limpiar', 'en-bombas'); ?></span>
            </div>
        </div>
    </div>

    <form id="enbombas-nitro-form" method="post">
        <?php wp_nonce_field('enbombas_nonce', 'enbombas_nonce'); ?>

        <!-- Navigation Tabs -->
        <div class="enb-tabs enbombas-nitro-tabs">
            <button type="button" class="enb-tab enb-tab-active enbombas-nitro-tab active" data-tab="css">
                <span class="enb-icon enb-icon-css"></span>
                <?php _e('CSS', 'en-bombas'); ?>
            </button>
            <button type="button" class="enb-tab enbombas-nitro-tab" data-tab="js">
                <span class="enb-icon enb-icon-js"></span>
                <?php _e('JavaScript', 'en-bombas'); ?>
            </button>
            <button type="button" class="enb-tab enbombas-nitro-tab" data-tab="cache">
                <span class="enb-icon enb-icon-cache"></span>
                <?php _e('Caché', 'en-bombas'); ?>
            </button>
            <button type="button" class="enb-tab enbombas-nitro-tab" data-tab="lazyload">
                <span class="enb-icon enb-icon-image"></span>
                <?php _e('LazyLoad', 'en-bombas'); ?>
            </button>
            <button type="button" class="enb-tab enbombas-nitro-tab" data-tab="preload">
                <span class="enb-icon enb-icon-preload"></span>
                <?php _e('Precarga', 'en-bombas'); ?>
            </button>
            <button type="button" class="enb-tab enbombas-nitro-tab" data-tab="database">
                <span class="enb-icon enb-icon-database"></span>
                <?php _e('Base de Datos', 'en-bombas'); ?>
            </button>
            <button type="button" class="enb-tab enbombas-nitro-tab" data-tab="heartbeat">
                <span class="enb-icon enb-icon-heartbeat"></span>
                <?php _e('Heartbeat', 'en-bombas'); ?>
            </button>
        </div>

        <!-- Tab Content: CSS -->
        <div class="enbombas-nitro-panel active" data-panel="css">
            <div class="enbombas-card">
                <div class="enbombas-card-header">
                    <span class="enb-icon enb-icon-css"></span>
                    <h3><?php _e('Optimización de CSS', 'en-bombas'); ?></h3>
                    <p><?php _e('Vea pues, parce, aquí puedes hacer que tu CSS vuele como un cohete.', 'en-bombas'); ?></p>
                </div>
                <div class="enbombas-card-body">
                    <div class="enbombas-option-group">
                        <div class="enb-icon-row">
                            <label class="enb-switch">
                                <input type="checkbox" name="css_minify" value="1" <?php checked($settings['css_minify'], true); ?>>
                                <span class="enb-switch-slider"></span>
                            </label>
                            <div>
                                <strong><?php _e('Minificar CSS', 'en-bombas'); ?></strong>
                                <small><?php _e('Reduce el tamaño de los archivos CSS eliminando espacios y comentarios.', 'en-bombas'); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <div class="enb-icon-row">
                            <label class="enb-switch">
                                <input type="checkbox" name="css_combine" value="1" <?php checked($settings['css_combine'], true); ?>>
                                <span class="enb-switch-slider"></span>
                            </label>
                            <div>
                                <strong><?php _e('Combinar CSS', 'en-bombas'); ?></strong>
                                <small><?php _e('Une múltiples archivos CSS en uno solo para reducir las solicitudes HTTP.', 'en-bombas'); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <div class="enb-icon-row">
                            <label class="enb-switch">
                                <input type="checkbox" name="css_async" value="1" <?php checked($settings['css_async'], true); ?>>
                                <span class="enb-switch-slider"></span>
                            </label>
                            <div>
                                <strong><?php _e('Carga asíncrona de CSS', 'en-bombas'); ?></strong>
                                <small><?php _e('Carga el CSS sin bloquear el renderizado de la página.', 'en-bombas'); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="enbombas-option-group enbombas-indent">
                        <label><?php _e('Método de carga asíncrona:', 'en-bombas'); ?></label>
                        <div class="enbombas-radio-group">
                            <label class="enbombas-radio">
                                <input type="radio" name="css_async_method" value="preload" <?php checked($settings['css_async_method'], 'preload'); ?>>
                                <span class="enbombas-radio-mark"></span>
                                <span><?php _e('Preload + onload (recomendado)', 'en-bombas'); ?></span>
                            </label>
                            <label class="enbombas-radio">
                                <input type="radio" name="css_async_method" value="media_print" <?php checked($settings['css_async_method'], 'media_print'); ?>>
                                <span class="enbombas-radio-mark"></span>
                                <span><?php _e('Media="print" trick', 'en-bombas'); ?></span>
                            </label>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <div class="enb-icon-row">
                            <label class="enb-switch">
                                <input type="checkbox" name="css_remove_unused" value="1" <?php checked($settings['css_remove_unused'], true); ?>>
                                <span class="enb-switch-slider"></span>
                            </label>
                            <div>
                                <strong><?php _e('Eliminar CSS no utilizado', 'en-bombas'); ?></strong>
                                <small><?php _e('Quita estilos que no se usan en la página. ¡Ojo! Puede afectar elementos dinámicos.', 'en-bombas'); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <label for="critical_css">
                            <strong><?php _e('CSS Crítico', 'en-bombas'); ?></strong>
                            <small><?php _e('Pega aquí el CSS crítico para cargar estilos above-the-fold inmediatamente.', 'en-bombas'); ?></small>
                        </label>
                        <textarea id="critical_css" name="critical_css" class="enbombas-textarea enbombas-code-textarea" rows="8" placeholder="/* Tu CSS crítico aquí */"><?php echo esc_textarea($settings['critical_css']); ?></textarea>
                    </div>

                    <div class="enbombas-option-group">
                        <label for="css_exclude">
                            <strong><?php _e('Excluir archivos CSS', 'en-bombas'); ?></strong>
                            <small><?php _e('Una URL o nombre de archivo por línea. Estos no serán optimizados.', 'en-bombas'); ?></small>
                        </label>
                        <textarea id="css_exclude" name="css_exclude" class="enbombas-textarea" rows="4" placeholder="elementor.min.css&#10;custom-styles.css"><?php echo esc_textarea(implode("\n", $settings['css_exclude'])); ?></textarea>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tab Content: JavaScript -->
        <div class="enbombas-nitro-panel" data-panel="js">
            <div class="enbombas-card">
                <div class="enbombas-card-header">
                    <span class="enb-icon enb-icon-js"></span>
                    <h3><?php _e('Optimización de JavaScript', 'en-bombas'); ?></h3>
                    <p><?php _e('Controla cómo se cargan los scripts para que tu sitio no se ponga lento.', 'en-bombas'); ?></p>
                </div>
                <div class="enbombas-card-body">
                    <div class="enbombas-option-group">
                        <div class="enb-icon-row">
                            <label class="enb-switch">
                                <input type="checkbox" name="js_minify" value="1" <?php checked($settings['js_minify'], true); ?>>
                                <span class="enb-switch-slider"></span>
                            </label>
                            <div>
                                <strong><?php _e('Minificar JavaScript', 'en-bombas'); ?></strong>
                                <small><?php _e('Hace que los archivos de JavaScript pesen menos para que tu página cargue más rápido. No cambia lo que hace tu sitio, solo lo adelgaza.', 'en-bombas'); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <div class="enb-icon-row">
                            <label class="enb-switch">
                                <input type="checkbox" name="js_combine" value="1" <?php checked($settings['js_combine'], true); ?>>
                                <span class="enb-switch-slider"></span>
                            </label>
                            <div>
                                <strong><?php _e('Combinar JavaScript', 'en-bombas'); ?></strong>
                                <small><?php _e('Une varios archivos de JS en uno solo para hacer menos pedidos al servidor. Úsalo si tu sitio carga muchos scripts diferentes.', 'en-bombas'); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <div class="enb-icon-row">
                            <label class="enb-switch">
                                <input type="checkbox" name="js_defer" value="1" <?php checked($settings['js_defer'], true); ?>>
                                <span class="enb-switch-slider"></span>
                            </label>
                            <div>
                                <strong><?php _e('Agregar atributo defer', 'en-bombas'); ?></strong>
                                <small><?php _e('Le decimos al navegador que primero cargue el contenido de la página y luego ejecute los scripts. Así el usuario ve todo más rápido.', 'en-bombas'); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <div class="enb-icon-row">
                            <label class="enb-switch">
                                <input type="checkbox" name="js_delay" value="1" <?php checked($settings['js_delay'], true); ?>>
                                <span class="enb-switch-slider"></span>
                            </label>
                            <div>
                                <strong><?php _e('Retrasar ejecución de JS', 'en-bombas'); ?></strong>
                                <small><?php _e('Dejamos quietos algunos scripts hasta que el usuario se mueva (scroll, clic, teclado). Perfecto para códigos que no son urgentes, como analíticas o widgets externos.', 'en-bombas'); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="enbombas-option-group enbombas-indent">
                        <label for="js_delay_timeout">
                            <strong><?php _e('Tiempo máximo de espera (ms)', 'en-bombas'); ?></strong>
                            <small><?php _e('Si el usuario no hace nada, cargamos los scripts después de este tiempo.', 'en-bombas'); ?></small>
                        </label>
                        <input type="number" id="js_delay_timeout" name="js_delay_timeout" value="<?php echo esc_attr($settings['js_delay_timeout']); ?>" min="1000" max="30000" step="500" class="enbombas-input enbombas-input-small">
                    </div>

                    <div class="enbombas-option-group">
                        <label for="js_exclude">
                            <strong><?php _e('Excluir archivos JS', 'en-bombas'); ?></strong>
                            <small><?php _e('Escribe aquí los scripts que NO quieres tocar (uno por línea). Ideal para código sensible o integraciones raras.', 'en-bombas'); ?></small>
                        </label>
                        <textarea id="js_exclude" name="js_exclude" class="enbombas-textarea" rows="4" placeholder="mi-script-critico.js&#10;analytics.js"><?php echo esc_textarea(implode("\n", $settings['js_exclude'])); ?></textarea>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tab Content: Cache -->
        <div class="enbombas-nitro-panel" data-panel="cache">
            <div class="enbombas-card">
                <div class="enbombas-card-header">
                    <span class="enb-icon enb-icon-cache"></span>
                    <h3><?php _e('Sistema de Caché', 'en-bombas'); ?></h3>
                    <p><?php _e('Genera versiones estáticas de tus páginas para servirlas en un parpadeo.', 'en-bombas'); ?></p>
                </div>
                <div class="enbombas-card-body">
                    <div class="enbombas-option-group">
                        <div class="enb-icon-row">
                            <label class="enb-switch">
                                <input type="checkbox" name="cache_enabled" value="1" <?php checked($settings['cache_enabled'], true); ?>>
                                <span class="enb-switch-slider"></span>
                            </label>
                            <div>
                                <strong><?php _e('Habilitar caché de páginas', 'en-bombas'); ?></strong>
                                <small><?php _e('Guardamos una copia estática de cada página para servirla casi al instante. Tu sitio se siente mucho más rápido, sobre todo en hosting básico.', 'en-bombas'); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <div class="enb-icon-row">
                            <label class="enb-switch">
                                <input type="checkbox" name="cache_mobile" value="1" <?php checked($settings['cache_mobile'], true); ?>>
                                <span class="enb-switch-slider"></span>
                            </label>
                            <div>
                                <strong><?php _e('Caché separado para móviles', 'en-bombas'); ?></strong>
                                <small><?php _e('Creamos una versión de caché especial para celulares y tablets. Úsalo si tu tema muestra cosas muy diferentes en móvil y escritorio.', 'en-bombas'); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <div class="enb-icon-row">
                            <label class="enb-switch">
                                <input type="checkbox" name="cache_logged_in" value="1" <?php checked($settings['cache_logged_in'], true); ?>>
                                <span class="enb-switch-slider"></span>
                            </label>
                            <div>
                                <strong><?php _e('Caché para usuarios logueados', 'en-bombas'); ?></strong>
                                <small><?php _e('También guardamos caché para usuarios que inician sesión (clientes, estudiantes, etc.). Úsalo solo si tu contenido no cambia según la persona.', 'en-bombas'); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <label for="cache_lifespan">
                            <strong><?php _e('Tiempo de vida del caché', 'en-bombas'); ?></strong>
                            <small><?php _e('Cuánto tiempo guardamos las páginas en caché antes de volver a generar una versión fresca.', 'en-bombas'); ?></small>
                        </label>
                        <select id="cache_lifespan" name="cache_lifespan" class="enbombas-select">
                            <option value="3600" <?php selected($settings['cache_lifespan'], 3600); ?>><?php _e('1 hora', 'en-bombas'); ?></option>
                            <option value="21600" <?php selected($settings['cache_lifespan'], 21600); ?>><?php _e('6 horas', 'en-bombas'); ?></option>
                            <option value="43200" <?php selected($settings['cache_lifespan'], 43200); ?>><?php _e('12 horas', 'en-bombas'); ?></option>
                            <option value="86400" <?php selected($settings['cache_lifespan'], 86400); ?>><?php _e('1 día', 'en-bombas'); ?></option>
                            <option value="604800" <?php selected($settings['cache_lifespan'], 604800); ?>><?php _e('7 días (recomendado)', 'en-bombas'); ?></option>
                            <option value="2592000" <?php selected($settings['cache_lifespan'], 2592000); ?>><?php _e('30 días', 'en-bombas'); ?></option>
                        </select>
                    </div>

                    <div class="enbombas-option-group">
                        <label for="cache_exclude_urls">
                            <strong><?php _e('Excluir URLs de la caché', 'en-bombas'); ?></strong>
                            <small><?php _e('Rutas que nunca deben guardarse en caché (una por línea). Ejemplo: páginas de cuenta, carrito, checkout o contenido muy dinámico.', 'en-bombas'); ?></small>
                        </label>
                        <textarea id="cache_exclude_urls" name="cache_exclude_urls" class="enbombas-textarea" rows="4" placeholder="/mi-cuenta/*&#10;/pagina-dinamica/"><?php echo esc_textarea(implode("\n", $settings['cache_exclude_urls'])); ?></textarea>
                    </div>

                    <!-- Cache Stats -->
                    <div class="enbombas-cache-stats">
                        <h4><?php _e('Estadísticas del Caché', 'en-bombas'); ?></h4>
                        <div class="enbombas-stats-grid">
                            <div class="enbombas-mini-stat">
                                <span class="enbombas-mini-stat-label"><?php _e('Archivos en caché:', 'en-bombas'); ?></span>
                                <span class="enbombas-mini-stat-value enb-accent-green"><?php echo esc_html($cache_stats['total_files']); ?></span>
                            </div>
                            <div class="enbombas-mini-stat">
                                <span class="enbombas-mini-stat-label"><?php _e('Tamaño total:', 'en-bombas'); ?></span>
                                <span class="enbombas-mini-stat-value enb-accent-blue"><?php echo esc_html($cache_stats['total_size_formatted']); ?></span>
                            </div>
                            <?php if ($cache_stats['oldest_cache']): ?>
                            <div class="enbombas-mini-stat">
                                <span class="enbombas-mini-stat-label"><?php _e('Caché más antiguo:', 'en-bombas'); ?></span>
                                <span class="enbombas-mini-stat-value"><?php echo esc_html($cache_stats['oldest_cache']); ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tab Content: LazyLoad -->
        <div class="enbombas-nitro-panel" data-panel="lazyload">
            <div class="enbombas-card">
                <div class="enbombas-card-header">
                    <span class="enb-icon enb-icon-image"></span>
                    <h3><?php _e('Carga Diferida (LazyLoad)', 'en-bombas'); ?></h3>
                    <p><?php _e('Carga imágenes y videos solo cuando el usuario los necesita. ¡Ahorra datos y acelera la carga!', 'en-bombas'); ?></p>
                </div>
                <div class="enbombas-card-body">
                    <div class="enbombas-option-group">
                        <div class="enb-icon-row">
                            <label class="enb-switch">
                                <input type="checkbox" name="lazyload_images" value="1" <?php checked($settings['lazyload_images'], true); ?>>
                                <span class="enb-switch-slider"></span>
                            </label>
                            <div>
                                <strong><?php _e('LazyLoad para imágenes', 'en-bombas'); ?></strong>
                                <small><?php _e('Carga las imágenes solo cuando entran en el viewport.', 'en-bombas'); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <div class="enb-icon-row">
                            <label class="enb-switch">
                                <input type="checkbox" name="lazyload_iframes" value="1" <?php checked($settings['lazyload_iframes'], true); ?>>
                                <span class="enb-switch-slider"></span>
                            </label>
                            <div>
                                <strong><?php _e('LazyLoad para iframes', 'en-bombas'); ?></strong>
                                <small><?php _e('Carga iframes (mapas, widgets) solo cuando son visibles.', 'en-bombas'); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <div class="enb-icon-row">
                            <label class="enb-switch">
                                <input type="checkbox" name="lazyload_youtube" value="1" <?php checked($settings['lazyload_youtube'], true); ?>>
                                <span class="enb-switch-slider"></span>
                            </label>
                            <div>
                                <strong><?php _e('Reemplazar YouTube con thumbnail', 'en-bombas'); ?></strong>
                                <small><?php _e('Muestra una miniatura de YouTube y carga el video solo al hacer click. ¡Ahorra muchísimos recursos!', 'en-bombas'); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <label for="lazyload_threshold">
                            <strong><?php _e('Distancia de precarga (px)', 'en-bombas'); ?></strong>
                            <small><?php _e('Cuántos píxeles antes de llegar al elemento comenzar a cargarlo.', 'en-bombas'); ?></small>
                        </label>
                        <input type="number" id="lazyload_threshold" name="lazyload_threshold" value="<?php echo esc_attr($settings['lazyload_threshold']); ?>" min="0" max="1000" step="50" class="enbombas-input enbombas-input-small">
                    </div>

                    <div class="enbombas-option-group">
                        <label for="lazyload_exclude">
                            <strong><?php _e('Excluir del LazyLoad', 'en-bombas'); ?></strong>
                            <small><?php _e('Clases CSS, IDs o partes de URLs a excluir. Una por línea.', 'en-bombas'); ?></small>
                        </label>
                        <textarea id="lazyload_exclude" name="lazyload_exclude" class="enbombas-textarea" rows="4" placeholder="logo&#10;hero-image&#10;no-lazy"><?php echo esc_textarea(implode("\n", $settings['lazyload_exclude'])); ?></textarea>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tab Content: Preload -->
        <div class="enbombas-nitro-panel" data-panel="preload">
            <div class="enbombas-card">
                <div class="enbombas-card-header">
                    <span class="enb-icon enb-icon-preload"></span>
                    <h3><?php _e('Precarga y Prefetch', 'en-bombas'); ?></h3>
                    <p><?php _e('Dile al navegador qué recursos cargar primero para que tu sitio se sienta instantáneo, parce.', 'en-bombas'); ?></p>
                </div>
                <div class="enbombas-card-body">
                    <div class="enbombas-option-group">
                        <label for="preload_fonts">
                            <strong><?php _e('Precargar fuentes', 'en-bombas'); ?></strong>
                            <small><?php _e('URLs completas de archivos de fuente (woff2, woff, ttf). Una por línea.', 'en-bombas'); ?></small>
                        </label>
                        <textarea id="preload_fonts" name="preload_fonts" class="enbombas-textarea" rows="4" placeholder="https://tusitio.com/wp-content/themes/tu-tema/fonts/mi-fuente.woff2"><?php echo esc_textarea(implode("\n", $settings['preload_fonts'])); ?></textarea>
                    </div>

                    <div class="enbombas-option-group">
                        <label for="preload_css">
                            <strong><?php _e('Precargar CSS', 'en-bombas'); ?></strong>
                            <small><?php _e('URLs de archivos CSS críticos para precargar. Una por línea.', 'en-bombas'); ?></small>
                        </label>
                        <textarea id="preload_css" name="preload_css" class="enbombas-textarea" rows="3" placeholder="https://tusitio.com/wp-content/themes/tu-tema/style.css"><?php echo esc_textarea(implode("\n", $settings['preload_css'])); ?></textarea>
                    </div>

                    <div class="enbombas-option-group">
                        <label for="preconnect_domains">
                            <strong><?php _e('Preconectar dominios', 'en-bombas'); ?></strong>
                            <small><?php _e('Dominios externos para establecer conexión anticipada (fonts.googleapis.com, cdn.ejemplo.com). Uno por línea.', 'en-bombas'); ?></small>
                        </label>
                        <textarea id="preconnect_domains" name="preconnect_domains" class="enbombas-textarea" rows="4" placeholder="fonts.googleapis.com&#10;fonts.gstatic.com&#10;cdnjs.cloudflare.com"><?php echo esc_textarea(implode("\n", $settings['preconnect_domains'])); ?></textarea>
                    </div>

                    <div class="enbombas-option-group">
                        <label for="dns_prefetch">
                            <strong><?php _e('DNS Prefetch', 'en-bombas'); ?></strong>
                            <small><?php _e('Dominios para resolver DNS anticipadamente. Menos agresivo que preconnect.', 'en-bombas'); ?></small>
                        </label>
                        <textarea id="dns_prefetch" name="dns_prefetch" class="enbombas-textarea" rows="3" placeholder="www.google-analytics.com&#10;connect.facebook.net"><?php echo esc_textarea(implode("\n", $settings['dns_prefetch'])); ?></textarea>
                    </div>

                    <div class="enbombas-info-box">
                        <span class="enb-icon enb-icon-info"></span>
                        <div>
                            <strong><?php _e('Consejo de rendimiento', 'en-bombas'); ?></strong>
                            <p><?php _e('Los dominios de Google Fonts (fonts.googleapis.com y fonts.gstatic.com) son candidatos ideales para preconnect si usas fuentes de Google.', 'en-bombas'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tab Content: Database -->
        <div class="enbombas-nitro-panel" data-panel="database">
            <div class="enbombas-card">
                <div class="enbombas-card-header">
                    <span class="enb-icon enb-icon-database"></span>
                    <h3><?php _e('Optimización de Base de Datos', 'en-bombas'); ?></h3>
                    <p><?php _e('Limpia la basura acumulada y mantén tu base de datos livianita, parce.', 'en-bombas'); ?></p>
                </div>
                <div class="enbombas-card-body">
                    <!-- Database Stats -->
                    <div class="enbombas-db-stats">
                        <h4><?php _e('Estado actual de la base de datos', 'en-bombas'); ?></h4>
                        <div class="enbombas-db-stats-grid">
                            <div class="enbombas-db-stat-item">
                                <span class="enbombas-db-stat-icon enb-icon-revision"></span>
                                <span class="enbombas-db-stat-label"><?php _e('Revisiones', 'en-bombas'); ?></span>
                                <span class="enbombas-db-stat-value <?php echo $db_stats['revisions'] > 0 ? 'has-items' : ''; ?>"><?php echo esc_html($db_stats['revisions']); ?></span>
                            </div>
                            <div class="enbombas-db-stat-item">
                                <span class="enbombas-db-stat-icon enb-icon-draft"></span>
                                <span class="enbombas-db-stat-label"><?php _e('Auto-borradores', 'en-bombas'); ?></span>
                                <span class="enbombas-db-stat-value <?php echo $db_stats['drafts'] > 0 ? 'has-items' : ''; ?>"><?php echo esc_html($db_stats['drafts']); ?></span>
                            </div>
                            <div class="enbombas-db-stat-item">
                                <span class="enbombas-db-stat-icon enb-icon-trash"></span>
                                <span class="enbombas-db-stat-label"><?php _e('En papelera', 'en-bombas'); ?></span>
                                <span class="enbombas-db-stat-value <?php echo $db_stats['trash'] > 0 ? 'has-items' : ''; ?>"><?php echo esc_html($db_stats['trash']); ?></span>
                            </div>
                            <div class="enbombas-db-stat-item">
                                <span class="enbombas-db-stat-icon enb-icon-spam"></span>
                                <span class="enbombas-db-stat-label"><?php _e('Spam', 'en-bombas'); ?></span>
                                <span class="enbombas-db-stat-value <?php echo $db_stats['spam_comments'] > 0 ? 'has-items' : ''; ?>"><?php echo esc_html($db_stats['spam_comments']); ?></span>
                            </div>
                            <div class="enbombas-db-stat-item">
                                <span class="enbombas-db-stat-icon enb-icon-transient"></span>
                                <span class="enbombas-db-stat-label"><?php _e('Transients expirados', 'en-bombas'); ?></span>
                                <span class="enbombas-db-stat-value <?php echo $db_stats['transients'] > 0 ? 'has-items' : ''; ?>"><?php echo esc_html($db_stats['transients']); ?></span>
                            </div>
                            <div class="enbombas-db-stat-item">
                                <span class="enbombas-db-stat-icon enb-icon-orphan"></span>
                                <span class="enbombas-db-stat-label"><?php _e('Meta huérfano', 'en-bombas'); ?></span>
                                <span class="enbombas-db-stat-value <?php echo $db_stats['orphan_meta'] > 0 ? 'has-items' : ''; ?>"><?php echo esc_html($db_stats['orphan_meta']); ?></span>
                            </div>
                        </div>

                        <button type="button" id="enb-optimize-db" class="enbombas-btn enbombas-btn-accent">
                            <span class="enb-icon enb-icon-cleanup"></span>
                            <?php _e('Limpiar y Optimizar Ahora', 'en-bombas'); ?>
                        </button>
                    </div>

                    <hr class="enbombas-divider">

                    <h4><?php _e('Opciones de limpieza automática', 'en-bombas'); ?></h4>

                    <div class="enbombas-option-group">
                        <label class="enbombas-toggle">
                            <input type="checkbox" name="db_clean_revisions" <?php checked($settings['db_clean_revisions']); ?>>
                            <span class="enbombas-toggle-slider"></span>
                            <span class="enbombas-toggle-label">
                                <strong><?php _e('Limpiar revisiones de posts', 'en-bombas'); ?></strong>
                            </span>
                        </label>
                    </div>

                    <div class="enbombas-option-group">
                        <label class="enbombas-toggle">
                            <input type="checkbox" name="db_clean_drafts" <?php checked($settings['db_clean_drafts']); ?>>
                            <span class="enbombas-toggle-slider"></span>
                            <span class="enbombas-toggle-label">
                                <strong><?php _e('Limpiar auto-borradores', 'en-bombas'); ?></strong>
                            </span>
                        </label>
                    </div>

                    <div class="enbombas-option-group">
                        <label class="enbombas-toggle">
                            <input type="checkbox" name="db_clean_trash" <?php checked($settings['db_clean_trash']); ?>>
                            <span class="enbombas-toggle-slider"></span>
                            <span class="enbombas-toggle-label">
                                <strong><?php _e('Vaciar papelera y spam', 'en-bombas'); ?></strong>
                            </span>
                        </label>
                    </div>

                    <div class="enbombas-option-group">
                        <label class="enbombas-toggle">
                            <input type="checkbox" name="db_clean_transients" <?php checked($settings['db_clean_transients']); ?>>
                            <span class="enbombas-toggle-slider"></span>
                            <span class="enbombas-toggle-label">
                                <strong><?php _e('Limpiar transients expirados', 'en-bombas'); ?></strong>
                            </span>
                        </label>
                    </div>

                    <div class="enbombas-option-group">
                        <label class="enbombas-toggle">
                            <input type="checkbox" name="db_optimize_tables" <?php checked($settings['db_optimize_tables']); ?>>
                            <span class="enbombas-toggle-slider"></span>
                            <span class="enbombas-toggle-label">
                                <strong><?php _e('Optimizar tablas de la BD', 'en-bombas'); ?></strong>
                                <small><?php _e('Ejecuta OPTIMIZE TABLE para reducir fragmentación.', 'en-bombas'); ?></small>
                            </span>
                        </label>
                    </div>

                    <hr class="enbombas-divider">

                    <div class="enbombas-option-group">
                        <label class="enbombas-toggle">
                            <input type="checkbox" name="db_auto_clean" <?php checked($settings['db_auto_clean']); ?>>
                            <span class="enbombas-toggle-slider"></span>
                            <span class="enbombas-toggle-label">
                                <strong><?php _e('Limpieza automática programada', 'en-bombas'); ?></strong>
                                <small><?php _e('Ejecuta la limpieza automáticamente según la frecuencia seleccionada.', 'en-bombas'); ?></small>
                            </span>
                        </label>
                    </div>

                    <div class="enbombas-option-group enbombas-indent">
                        <label for="db_auto_clean_frequency">
                            <strong><?php _e('Frecuencia de limpieza', 'en-bombas'); ?></strong>
                        </label>
                        <select id="db_auto_clean_frequency" name="db_auto_clean_frequency" class="enbombas-select">
                            <option value="daily" <?php selected($settings['db_auto_clean_frequency'], 'daily'); ?>><?php _e('Diaria', 'en-bombas'); ?></option>
                            <option value="weekly" <?php selected($settings['db_auto_clean_frequency'], 'weekly'); ?>><?php _e('Semanal (recomendado)', 'en-bombas'); ?></option>
                            <option value="monthly" <?php selected($settings['db_auto_clean_frequency'], 'monthly'); ?>><?php _e('Mensual', 'en-bombas'); ?></option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tab Content: Heartbeat -->
        <div class="enbombas-nitro-panel" data-panel="heartbeat">
            <div class="enbombas-card">
                <div class="enbombas-card-header">
                    <span class="enb-icon enb-icon-heartbeat"></span>
                    <h3><?php _e('Control del Heartbeat', 'en-bombas'); ?></h3>
                    <p><?php _e('Controla el "latido" de WordPress que envía solicitudes AJAX periódicas.', 'en-bombas'); ?></p>
                </div>
                <div class="enbombas-card-body">
                    <div class="enbombas-info-box enbombas-info-box-warning">
                        <span class="enb-icon enb-icon-warning"></span>
                        <div>
                            <strong><?php _e('¿Qué es el Heartbeat?', 'en-bombas'); ?></strong>
                            <p><?php _e('El Heartbeat de WordPress es una API que envía solicitudes AJAX periódicas para mantener funciones como autoguardado, bloqueo de posts y notificaciones en tiempo real. Reducir o desactivar el Heartbeat puede mejorar el rendimiento, especialmente en servidores compartidos, pero puede afectar algunas funcionalidades del editor.', 'en-bombas'); ?></p>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <label><strong><?php _e('Comportamiento del Heartbeat', 'en-bombas'); ?></strong></label>
                        <div class="enbombas-radio-cards">
                            <label class="enbombas-radio-card <?php echo $settings['heartbeat_behavior'] === 'default' ? 'active' : ''; ?>">
                                <input type="radio" name="heartbeat_behavior" value="default" <?php checked($settings['heartbeat_behavior'], 'default'); ?>>
                                <span class="enbombas-radio-card-icon enb-icon-check"></span>
                                <span class="enbombas-radio-card-title"><?php _e('Por defecto', 'en-bombas'); ?></span>
                                <span class="enbombas-radio-card-desc"><?php _e('Mantiene la configuración original de WordPress.', 'en-bombas'); ?></span>
                            </label>

                            <label class="enbombas-radio-card <?php echo $settings['heartbeat_behavior'] === 'reduce' ? 'active' : ''; ?>">
                                <input type="radio" name="heartbeat_behavior" value="reduce" <?php checked($settings['heartbeat_behavior'], 'reduce'); ?>>
                                <span class="enbombas-radio-card-icon enb-icon-slow"></span>
                                <span class="enbombas-radio-card-title"><?php _e('Reducir frecuencia', 'en-bombas'); ?></span>
                                <span class="enbombas-radio-card-desc"><?php _e('Envía solicitudes con menos frecuencia.', 'en-bombas'); ?></span>
                            </label>

                            <label class="enbombas-radio-card <?php echo $settings['heartbeat_behavior'] === 'disable' ? 'active' : ''; ?>">
                                <input type="radio" name="heartbeat_behavior" value="disable" <?php checked($settings['heartbeat_behavior'], 'disable'); ?>>
                                <span class="enbombas-radio-card-icon enb-icon-stop"></span>
                                <span class="enbombas-radio-card-title"><?php _e('Desactivar', 'en-bombas'); ?></span>
                                <span class="enbombas-radio-card-desc"><?php _e('Desactiva el Heartbeat completamente. Puede afectar funcionalidades.', 'en-bombas'); ?></span>
                            </label>
                        </div>
                    </div>

                    <div class="enbombas-option-group enbombas-indent" id="heartbeat-frequency-group">
                        <label for="heartbeat_frequency">
                            <strong><?php _e('Intervalo del Heartbeat (segundos)', 'en-bombas'); ?></strong>
                            <small><?php _e('Por defecto es 15-60 segundos. Valores más altos reducen la carga del servidor.', 'en-bombas'); ?></small>
                        </label>
                        <input type="range" id="heartbeat_frequency" name="heartbeat_frequency" value="<?php echo esc_attr($settings['heartbeat_frequency']); ?>" min="15" max="120" step="5" class="enbombas-slider">
                        <div class="enbombas-slider-labels">
                            <span>15s</span>
                            <span class="enbombas-slider-value"><?php echo esc_html($settings['heartbeat_frequency']); ?>s</span>
                            <span>120s</span>
                        </div>
                    </div>

                    <div class="enbombas-option-group">
                        <label class="enbombas-toggle">
                            <input type="checkbox" name="heartbeat_backend_only" <?php checked($settings['heartbeat_backend_only']); ?>>
                            <span class="enbombas-toggle-slider"></span>
                            <span class="enbombas-toggle-label">
                                <strong><?php _e('Solo en el escritorio (admin)', 'en-bombas'); ?></strong>
                                <small><?php _e('Desactiva el Heartbeat en el frontend para visitantes.', 'en-bombas'); ?></small>
                            </span>
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Toast container -->
    <div id="enbombas-toast-container"></div>
</div>
</div>

