<?php
/**
 * Dashboard Template
 *
 * @package EnBombas
 */

if (!defined('ABSPATH')) {
    exit;
}

$ai_status = $monitor->get_ai_status();
$health_score = $monitoring_data['health_score'] ?? 100;
$alerts = $monitoring_data['alerts'] ?? [];

// SVG Icons
$icons = [
    'rocket' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M4.5 16.5c-1.5 1.26-2 5-2 5s3.74-.5 5-2c.71-.84.7-2.13-.09-2.91a2.18 2.18 0 0 0-2.91-.09z"/><path d="m12 15-3-3a22 22 0 0 1 2-3.95A12.88 12.88 0 0 1 22 2c0 2.72-.78 7.5-6 11a22.35 22.35 0 0 1-4 2z"/><path d="M9 12H4s.55-3.03 2-4c1.62-1.08 5 0 5 0"/><path d="M12 15v5s3.03-.55 4-2c1.08-1.62 0-5 0-5"/></svg>',
    'bolt' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"/></svg>',
    'image' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"/><circle cx="8.5" cy="8.5" r="1.5"/><polyline points="21 15 16 10 5 21"/></svg>',
    'clock' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><polyline points="12 6 12 12 16 14"/></svg>',
    'calendar' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="4" width="18" height="18" rx="2" ry="2"/><line x1="16" y1="2" x2="16" y2="6"/><line x1="8" y1="2" x2="8" y2="6"/><line x1="3" y1="10" x2="21" y2="10"/></svg>',
    'settings' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="3"/><path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"/></svg>',
    'folder' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"/></svg>',
    'cpu' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="4" y="4" width="16" height="16" rx="2" ry="2"/><rect x="9" y="9" width="6" height="6"/><line x1="9" y1="1" x2="9" y2="4"/><line x1="15" y1="1" x2="15" y2="4"/><line x1="9" y1="20" x2="9" y2="23"/><line x1="15" y1="20" x2="15" y2="23"/><line x1="20" y1="9" x2="23" y2="9"/><line x1="20" y1="14" x2="23" y2="14"/><line x1="1" y1="9" x2="4" y2="9"/><line x1="1" y1="14" x2="4" y2="14"/></svg>',
    'search' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="11" cy="11" r="8"/><line x1="21" y1="21" x2="16.65" y2="16.65"/></svg>',
    'alert' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"/><line x1="12" y1="9" x2="12" y2="13"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>',
    'check' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="20 6 9 17 4 12"/></svg>',
    'x' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"/><line x1="6" y1="6" x2="18" y2="18"/></svg>',
    'ruler' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21.3 15.3a2.4 2.4 0 0 1 0 3.4l-2.6 2.6a2.4 2.4 0 0 1-3.4 0L2.7 8.7a2.41 2.41 0 0 1 0-3.4l2.6-2.6a2.41 2.41 0 0 1 3.4 0Z"/><path d="m14.5 12.5 2-2"/><path d="m11.5 9.5 2-2"/><path d="m8.5 6.5 2-2"/><path d="m17.5 15.5 2-2"/></svg>',
];

// Get AI status icon
$ai_icon = match($ai_status['status']) {
    'excellent' => $icons['rocket'],
    'good' => $icons['bolt'],
    'warning' => $icons['alert'],
    default => $icons['x']
};
?>

<div class="enbombas-wrapper">
<div class="enbombas-admin-wrap">
    <!-- Header -->
    <div class="enbombas-header">
        <div class="enbombas-header-content">
            <div class="enbombas-logo">
                <div class="enb-logo-icon">
                    <span class="enb-icon"><?php echo $icons['rocket']; ?></span>
                </div>
                <div>
                    <h1><?php _e('En Bombas', 'en-bombas'); ?></h1>
                    <div class="enbombas-logo-subtitle"><?php _e('Optimizador de Imágenes con IA', 'en-bombas'); ?></div>
                </div>
            </div>
            <div class="enbombas-header-stats">
                <div class="enbombas-header-stat">
                    <span class="enbombas-header-stat-value"><?php echo esc_html($stats['optimized_images']); ?></span>
                    <span class="enbombas-header-stat-label"><?php _e('Optimizadas', 'en-bombas'); ?></span>
                </div>
                <div class="enbombas-header-stat">
                    <span class="enbombas-header-stat-value"><?php echo esc_html($stats['total_saved_formatted']); ?></span>
                    <span class="enbombas-header-stat-label"><?php _e('Guardado Total', 'en-bombas'); ?></span>
                </div>
                <div class="enbombas-header-stat">
                    <span class="enbombas-header-stat-value"><?php echo esc_html($stats['optimization_rate']); ?>%</span>
                    <span class="enbombas-header-stat-label"><?php _e('Porcentaje', 'en-bombas'); ?></span>
                </div>
            </div>
        </div>
    </div>

    <div class="enbombas-dashboard-grid">
        <div class="enbombas-main-content">
            <!-- AI Status Card -->
            <div class="enbombas-card enbombas-ai-status">
                <div class="enbombas-ai-status-content">
                    <div class="enb-ai-icon-container">
                        <span class="enb-icon"><?php echo $ai_icon; ?></span>
                    </div>
                    <div class="enbombas-ai-info">
                        <h3><?php echo esc_html($ai_status['title']); ?></h3>
                        <p><?php echo esc_html($ai_status['message']); ?></p>
                    </div>
                    <div class="enbombas-ai-score">
                        <div class="enbombas-score-ring" data-score="<?php echo esc_attr($health_score); ?>">
                            <svg width="100" height="100">
                                <circle class="bg" cx="50" cy="50" r="42"></circle>
                                <circle class="progress" cx="50" cy="50" r="42"></circle>
                            </svg>
                            <span class="enbombas-score-value"><?php echo esc_html($health_score); ?></span>
                        </div>
                        <div class="enbombas-score-label"><?php _e('Puntuación de Salud', 'en-bombas'); ?></div>
                    </div>
                </div>
            </div>

            <!-- Alerts -->
            <?php if (!empty($alerts)): ?>
                <div class="enbombas-alerts">
                    <?php foreach ($alerts as $alert): ?>
                        <div class="enbombas-alert enbombas-alert-<?php echo esc_attr($alert['severity']); ?>">
                            <span class="enbombas-alert-icon">
                                <span class="enb-icon">
                                    <?php
                                    echo match($alert['type']) {
                                        'unoptimized' => $icons['image'],
                                        'oversized' => $icons['ruler'],
                                        'large_banner' => $icons['image'],
                                        'queue_warning' => $icons['clock'],
                                        default => $icons['alert']
                                    };
                                    ?>
                                </span>
                            </span>
                            <div class="enbombas-alert-content">
                                <div class="enbombas-alert-title">
                                    <?php
                                    echo match($alert['type']) {
                                        'unoptimized' => __('Imágenes sin optimizar', 'en-bombas'),
                                        'oversized' => __('Imágenes muy pesadas', 'en-bombas'),
                                        'large_banner' => __('Banners muy grandes', 'en-bombas'),
                                        'queue_warning' => __('Cola de espera', 'en-bombas'),
                                        default => __('Alerta', 'en-bombas')
                                    };
                                    ?>
                                </div>
                                <div class="enbombas-alert-message"><?php echo esc_html($alert['message']); ?></div>
                            </div>
                            <?php if ($alert['type'] === 'unoptimized'): ?>
                                <a href="<?php echo esc_url(admin_url('admin.php?page=en-bombas-bulk')); ?>" class="enbombas-alert-action">
                                    <?php _e('Optimizar ahora', 'en-bombas'); ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <!-- Statistics Grid -->
            <div class="enbombas-stats-grid">
                <div class="enbombas-stat-card">
                    <div class="enb-icon-bg"><span class="enb-icon"><?php echo $icons['image']; ?></span></div>
                    <div class="enbombas-stat-value"><?php echo esc_html($stats['total_images']); ?></div>
                    <div class="enbombas-stat-label"><?php _e('Total de Imágenes', 'en-bombas'); ?></div>
                </div>
                <div class="enbombas-stat-card">
                    <div class="enb-icon-bg"><span class="enb-icon"><?php echo $icons['bolt']; ?></span></div>
                    <div class="enbombas-stat-value"><?php echo esc_html($stats['optimized_images']); ?></div>
                    <div class="enbombas-stat-label"><?php _e('Optimizadas', 'en-bombas'); ?></div>
                </div>
                <div class="enbombas-stat-card">
                    <div class="enb-icon-bg"><span class="enb-icon"><?php echo $icons['clock']; ?></span></div>
                    <div class="enbombas-stat-value"><?php echo esc_html($stats['unoptimized_images']); ?></div>
                    <div class="enbombas-stat-label"><?php _e('Pendientes', 'en-bombas'); ?></div>
                </div>
                <div class="enbombas-stat-card">
                    <div class="enb-icon-bg"><span class="enb-icon"><?php echo $icons['calendar']; ?></span></div>
                    <div class="enbombas-stat-value"><?php echo esc_html($stats['monthly_optimized']); ?></div>
                    <div class="enbombas-stat-label"><?php _e('Este Mes', 'en-bombas'); ?></div>
                </div>
            </div>
        </div>

        <div class="enbombas-sidebar">
            <!-- Quick Actions -->
            <div class="enbombas-card">
                <div class="enbombas-card-header">
                    <h3 class="enbombas-card-title">
                        <span class="enb-icon"><?php echo $icons['bolt']; ?></span>
                        <?php _e('Acciones Rápidas', 'en-bombas'); ?>
                    </h3>
                </div>
                <div class="enbombas-quick-actions">
                    <a href="<?php echo esc_url(admin_url('admin.php?page=en-bombas-bulk')); ?>" class="enbombas-quick-action">
                        <span class="enbombas-quick-action-icon"><span class="enb-icon"><?php echo $icons['rocket']; ?></span></span>
                        <span class="enbombas-quick-action-label"><?php _e('Optimizar todo', 'en-bombas'); ?></span>
                    </a>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=en-bombas-settings')); ?>" class="enbombas-quick-action">
                        <span class="enbombas-quick-action-icon"><span class="enb-icon"><?php echo $icons['settings']; ?></span></span>
                        <span class="enbombas-quick-action-label"><?php _e('Configuración', 'en-bombas'); ?></span>
                    </a>
                    <a href="<?php echo esc_url(admin_url('upload.php')); ?>" class="enbombas-quick-action">
                        <span class="enbombas-quick-action-icon"><span class="enb-icon"><?php echo $icons['image']; ?></span></span>
                        <span class="enbombas-quick-action-label"><?php _e('Biblioteca de medios', 'en-bombas'); ?></span>
                    </a>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=en-bombas-folders')); ?>" class="enbombas-quick-action">
                        <span class="enbombas-quick-action-icon"><span class="enb-icon"><?php echo $icons['folder']; ?></span></span>
                        <span class="enbombas-quick-action-label"><?php _e('Carpetas personalizadas', 'en-bombas'); ?></span>
                    </a>
                </div>
            </div>

            <!-- AI Monitoring -->
            <div class="enbombas-card">
                <div class="enbombas-card-header">
                    <h3 class="enbombas-card-title">
                        <span class="enb-icon"><?php echo $icons['cpu']; ?></span>
                        <?php _e('Monitoreo IA', 'en-bombas'); ?>
                    </h3>
                    <?php if ($settings['monitoring_enabled']): ?>
                        <span class="enbombas-card-badge"><?php _e('Activo', 'en-bombas'); ?></span>
                    <?php endif; ?>
                </div>
                <div class="enbombas-card-content">
                    <p style="color: var(--enbombas-light-purple); margin-bottom: 16px;">
                        <?php
                        $last_scan = $monitoring_data['last_scan'] ?? null;
                        if ($last_scan) {
                            printf(
                                __('Último escaneo: hace %s', 'en-bombas'),
                                esc_html(human_time_diff(strtotime($last_scan), current_time('timestamp')))
                            );
                        } else {
                            _e('No se ha realizado ningún escaneo.', 'en-bombas');
                        }
                        ?>
                    </p>
                    <button type="button" class="enbombas-btn enbombas-btn-secondary enbombas-run-scan" style="width: 100%;">
                        <span class="enb-icon"><?php echo $icons['search']; ?></span>
                        <?php _e('Escanear con IA', 'en-bombas'); ?>
                    </button>
                </div>
            </div>

            <!-- Current Settings -->
            <div class="enbombas-card">
                <div class="enbombas-card-header">
                    <h3 class="enbombas-card-title">
                        <span class="enb-icon"><?php echo $icons['settings']; ?></span>
                        <?php _e('Configuración Actual', 'en-bombas'); ?>
                    </h3>
                </div>
                <div class="enbombas-card-content" style="color: var(--enbombas-light-purple);">
                    <p>
                        <strong style="color: var(--enbombas-white);"><?php _e('Compresión:', 'en-bombas'); ?></strong>
                        <?php echo esc_html(ucfirst($settings['compression_level'])); ?>
                        <?php if ($settings['compression_level'] === 'smart'): ?>
                            <span class="enbombas-card-badge" style="font-size: 10px; padding: 2px 8px;">IA</span>
                        <?php endif; ?>
                    </p>
                    <p>
                        <strong style="color: var(--enbombas-white);"><?php _e('Auto-optimizar:', 'en-bombas'); ?></strong>
                        <span class="<?php echo $settings['auto_optimize'] ? 'enb-status-on' : 'enb-status-off'; ?>">
                            <?php echo $settings['auto_optimize'] ? __('Sí', 'en-bombas') : __('No', 'en-bombas'); ?>
                        </span>
                    </p>
                    <p>
                        <strong style="color: var(--enbombas-white);">WebP:</strong>
                        <span class="<?php echo $settings['generate_webp'] ? 'enb-status-on' : 'enb-status-off'; ?>">
                            <?php echo $settings['generate_webp'] ? __('Sí', 'en-bombas') : __('No', 'en-bombas'); ?>
                        </span>
                    </p>
                    <p>
                        <strong style="color: var(--enbombas-white);">AVIF:</strong>
                        <span class="<?php echo $settings['generate_avif'] ? 'enb-status-on' : 'enb-status-off'; ?>">
                            <?php echo $settings['generate_avif'] ? __('Sí', 'en-bombas') : __('No', 'en-bombas'); ?>
                        </span>
                    </p>
                    <p>
                        <strong style="color: var(--enbombas-white);"><?php _e('Respaldo:', 'en-bombas'); ?></strong>
                        <span class="<?php echo $settings['backup_enabled'] ? 'enb-status-on' : 'enb-status-off'; ?>">
                            <?php echo $settings['backup_enabled'] ? __('Sí', 'en-bombas') : __('No', 'en-bombas'); ?>
                        </span>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
