<?php
/**
 * Custom Folders Template
 *
 * @package EnBombas
 */

if (!defined('ABSPATH')) {
    exit;
}

// SVG Icons
$icons = [
    'folder' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"/></svg>',
    'folder-plus' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"/><line x1="12" y1="11" x2="12" y2="17"/><line x1="9" y1="14" x2="15" y2="14"/></svg>',
    'save' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/><polyline points="17 21 17 13 7 13 7 21"/><polyline points="7 3 7 8 15 8"/></svg>',
    'lightbulb' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M15 14c.2-1 .7-1.7 1.5-2.5 1-.9 1.5-2.2 1.5-3.5A6 6 0 0 0 6 8c0 1 .2 2.2 1.5 3.5.7.7 1.3 1.5 1.5 2.5"/><path d="M9 18h6"/><path d="M10 22h4"/></svg>',
    'alert' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"/><line x1="12" y1="9" x2="12" y2="13"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>',
    'plus' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="12" y1="5" x2="12" y2="19"/><line x1="5" y1="12" x2="19" y2="12"/></svg>',
];
?>

<div class="enbombas-wrapper">
<div class="enbombas-admin-wrap">
    <!-- Header -->
    <div class="enbombas-header">
        <div class="enbombas-header-content">
            <div class="enbombas-logo">
                <div class="enb-logo-icon">
                    <span class="enb-icon"><?php echo $icons['folder']; ?></span>
                </div>
                <div>
                    <h1><?php _e('Carpetas Personalizadas', 'en-bombas'); ?></h1>
                    <div class="enbombas-logo-subtitle"><?php _e('Optimiza imágenes fuera de la Biblioteca de Medios', 'en-bombas'); ?></div>
                </div>
            </div>
        </div>
    </div>

    <form id="enbombas-settings-form" method="post">
        <div class="enbombas-card">
            <div class="enbombas-card-header">
                <h3 class="enbombas-card-title">
                    <span class="enb-icon"><?php echo $icons['folder-plus']; ?></span>
                    <?php _e('Carpetas Registradas', 'en-bombas'); ?>
                </h3>
            </div>

            <p style="color: var(--enbombas-light-purple); margin-bottom: 24px;">
                <?php _e('Agrega carpetas que contengan imágenes que deban incluirse en la optimización masiva. Pueden ser carpetas del tema, assets de plugins o cualquier directorio personalizado.', 'en-bombas'); ?>
            </p>

            <div class="enbombas-folders-list">
                <?php if (!empty($custom_folders)): ?>
                    <?php foreach ($custom_folders as $folder): ?>
                        <div class="enbombas-folder-item">
                            <span class="enb-icon"><?php echo $icons['folder']; ?></span>
                            <span class="enbombas-folder-path"><?php echo esc_html($folder); ?></span>
                            <input type="hidden" name="custom_folders[]" value="<?php echo esc_attr($folder); ?>">
                            <button type="button" class="enbombas-folder-remove">×</button>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p style="color: var(--enbombas-light-purple); text-align: center; padding: 20px;">
                        <?php _e('No se han agregado carpetas personalizadas todavía.', 'en-bombas'); ?>
                    </p>
                <?php endif; ?>
            </div>

            <div class="enbombas-folder-add" style="margin-top: 24px;">
                <input type="text" id="enbombas-new-folder" class="enbombas-form-input" placeholder="<?php esc_attr_e('/ruta/a/la/carpeta', 'en-bombas'); ?>" style="flex: 1; max-width: none;">
                <button type="button" class="enbombas-btn enbombas-btn-secondary enbombas-folder-add-btn">
                    <span class="enb-icon"><?php echo $icons['plus']; ?></span>
                    <?php _e('Agregar Carpeta', 'en-bombas'); ?>
                </button>
            </div>

            <div style="margin-top: 32px;">
                <button type="submit" class="enbombas-btn enbombas-btn-primary">
                    <span class="enb-icon"><?php echo $icons['save']; ?></span>
                    <?php _e('Guardar Carpetas', 'en-bombas'); ?>
                </button>
            </div>
        </div>

        <!-- Suggested Folders -->
        <div class="enbombas-card">
            <div class="enbombas-card-header">
                <h3 class="enbombas-card-title">
                    <span class="enb-icon"><?php echo $icons['lightbulb']; ?></span>
                    <?php _e('Carpetas Sugeridas', 'en-bombas'); ?>
                </h3>
            </div>

            <p style="color: var(--enbombas-light-purple); margin-bottom: 16px;">
                <?php _e('Carpetas comunes que pueden contener imágenes para optimizar:', 'en-bombas'); ?>
            </p>

            <div class="enbombas-folders-list">
                <?php
                $suggested_folders = [
                    get_template_directory() . '/images' => __('Imágenes del Tema', 'en-bombas'),
                    get_template_directory() . '/assets/images' => __('Assets del Tema', 'en-bombas'),
                    WP_CONTENT_DIR . '/cache' => __('Carpeta de Caché', 'en-bombas'),
                ];

                foreach ($suggested_folders as $path => $label):
                    if (is_dir($path) && !in_array($path, $custom_folders)):
                ?>
                    <div class="enbombas-folder-item" style="cursor: pointer;" onclick="document.getElementById('enbombas-new-folder').value = '<?php echo esc_js($path); ?>'">
                        <span class="enb-icon"><?php echo $icons['folder']; ?></span>
                        <span class="enbombas-folder-path"><?php echo esc_html($path); ?></span>
                        <span style="color: var(--enbombas-light-purple); font-size: 12px;"><?php echo esc_html($label); ?></span>
                    </div>
                <?php
                    endif;
                endforeach;
                ?>
            </div>
        </div>

        <!-- Warning -->
        <div class="enbombas-alert enbombas-alert-warning" style="margin-top: 24px;">
            <span class="enbombas-alert-icon"><span class="enb-icon"><?php echo $icons['alert']; ?></span></span>
            <div class="enbombas-alert-content">
                <div class="enbombas-alert-title"><?php _e('Nota Importante', 'en-bombas'); ?></div>
                <div class="enbombas-alert-message">
                    <?php _e('Las imágenes en carpetas personalizadas se optimizan directamente sin respaldo. Asegúrate de tener respaldos de archivos importantes del tema o plugins antes de optimizar, parce.', 'en-bombas'); ?>
                </div>
            </div>
        </div>
    </form>
</div>
</div>
