<?php
/**
 * Bulk Optimizer Template
 *
 * @package EnBombas
 */

if (!defined('ABSPATH')) {
    exit;
}

$bulk_status = $plugin->get_bulk_optimizer()->get_status();
$is_running = $bulk_status['running'] ?? false;

// SVG Icons
$icons = [
    'rocket' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M4.5 16.5c-1.5 1.26-2 5-2 5s3.74-.5 5-2c.71-.84.7-2.13-.09-2.91a2.18 2.18 0 0 0-2.91-.09z"/><path d="m12 15-3-3a22 22 0 0 1 2-3.95A12.88 12.88 0 0 1 22 2c0 2.72-.78 7.5-6 11a22.35 22.35 0 0 1-4 2z"/><path d="M9 12H4s.55-3.03 2-4c1.62-1.08 5 0 5 0"/><path d="M12 15v5s3.03-.55 4-2c1.08-1.62 0-5 0-5"/></svg>',
    'bolt' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"/></svg>',
    'image' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"/><circle cx="8.5" cy="8.5" r="1.5"/><polyline points="21 15 16 10 5 21"/></svg>',
    'palette' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="13.5" cy="6.5" r=".5"/><circle cx="17.5" cy="10.5" r=".5"/><circle cx="8.5" cy="7.5" r=".5"/><circle cx="6.5" cy="12.5" r=".5"/><path d="M12 2C6.5 2 2 6.5 2 12s4.5 10 10 10c.926 0 1.648-.746 1.648-1.688 0-.437-.18-.835-.437-1.125-.29-.289-.438-.652-.438-1.125a1.64 1.64 0 0 1 1.668-1.668h1.996c3.051 0 5.555-2.503 5.555-5.555C21.965 6.012 17.461 2 12 2z"/></svg>',
    'save' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/><polyline points="17 21 17 13 7 13 7 21"/><polyline points="7 3 7 8 15 8"/></svg>',
    'stop' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"/></svg>',
    'zap' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"/></svg>',
    'cpu' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="4" y="4" width="16" height="16" rx="2" ry="2"/><rect x="9" y="9" width="6" height="6"/><line x1="9" y1="1" x2="9" y2="4"/><line x1="15" y1="1" x2="15" y2="4"/><line x1="9" y1="20" x2="9" y2="23"/><line x1="15" y1="20" x2="15" y2="23"/><line x1="20" y1="9" x2="23" y2="9"/><line x1="20" y1="14" x2="23" y2="14"/><line x1="1" y1="9" x2="4" y2="9"/><line x1="1" y1="14" x2="4" y2="14"/></svg>',
    'lightbulb' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M15 14c.2-1 .7-1.7 1.5-2.5 1-.9 1.5-2.2 1.5-3.5A6 6 0 0 0 6 8c0 1 .2 2.2 1.5 3.5.7.7 1.3 1.5 1.5 2.5"/><path d="M9 18h6"/><path d="M10 22h4"/></svg>',
];
?>

<div class="enbombas-wrapper">
<div class="enbombas-admin-wrap">
    <!-- Header -->
    <div class="enbombas-header">
        <div class="enbombas-header-content">
            <div class="enbombas-logo">
                <div class="enb-logo-icon">
                    <span class="enb-icon"><?php echo $icons['rocket']; ?></span>
                </div>
                <div>
                    <h1><?php _e('Optimizador Masivo', 'en-bombas'); ?></h1>
                    <div class="enbombas-logo-subtitle"><?php _e('Optimiza todas tus imágenes de una vez', 'en-bombas'); ?></div>
                </div>
            </div>
            <?php if ($settings['turbo_mode']): ?>
                <span class="enbombas-card-badge" style="font-size: 14px;">
                    <span class="enb-icon" style="width:14px;height:14px;margin-right:4px;"><?php echo $icons['zap']; ?></span>
                    <?php _e('Modo Turbo Activo', 'en-bombas'); ?>
                </span>
            <?php endif; ?>
        </div>
    </div>

    <div class="enbombas-card">
        <div class="enbombas-bulk-container">
            <h2 class="enbombas-bulk-title"><?php _e('Optimización Masiva de Imágenes', 'en-bombas'); ?></h2>
            <p class="enbombas-bulk-subtitle">
                <?php if ($unoptimized_count > 0): ?>
                    <?php _e('Optimiza todas las imágenes sin procesar de tu Biblioteca de Medios con un solo clic.', 'en-bombas'); ?>
                <?php else: ?>
                    <?php _e('¡Todas tus imágenes ya están optimizadas, parcero!', 'en-bombas'); ?>
                <?php endif; ?>
            </p>

            <div class="enbombas-bulk-count"><?php echo esc_html($unoptimized_count); ?></div>
            <div class="enbombas-bulk-count-label"><?php _e('Imágenes por Optimizar', 'en-bombas'); ?></div>

            <!-- Circular Progress Button -->
            <div class="enb-bulk-center">
                <button id="enb-bulk-button" 
                        class="enb-bulk-circle <?php echo $is_running ? 'enb-bulk-running' : ''; ?>" 
                        data-total="<?php echo esc_attr($unoptimized_count); ?>"
                        <?php echo $unoptimized_count === 0 ? 'disabled' : ''; ?>>
                    <svg class="enb-bulk-ring" viewBox="0 0 120 120">
                        <circle class="enb-ring-bg" cx="60" cy="60" r="54" />
                        <circle class="enb-ring-progress" cx="60" cy="60" r="54" />
                    </svg>
                    <div class="enb-bulk-content">
                        <span class="enb-icon enb-icon-xl"><?php echo $icons['rocket']; ?></span>
                        <span class="enb-bulk-label">
                            <?php 
                            if ($is_running) {
                                _e('Optimizando imágenes...', 'en-bombas');
                            } else {
                                _e('Empezar optimización', 'en-bombas');
                            }
                            ?>
                        </span>
                        <span class="enb-bulk-percent"><?php echo esc_html(($bulk_status['progress'] ?? 0) . '%'); ?></span>
                    </div>
                </button>
            </div>

            <!-- Stop Button -->
            <div class="enb-stop-btn" style="text-align: center; <?php echo $is_running ? '' : 'display: none;'; ?>">
                <button type="button" id="enbombas-stop-bulk" class="enbombas-btn enbombas-btn-danger">
                    <span class="enb-icon"><?php echo $icons['stop']; ?></span>
                    <?php _e('Detener', 'en-bombas'); ?>
                </button>
            </div>

            <!-- Bulk Stats -->
            <div class="enbombas-bulk-stats">
                <div class="enbombas-bulk-stat">
                    <div class="enbombas-bulk-stat-value" id="enbombas-bulk-processed"><?php echo esc_html($bulk_status['processed'] ?? 0); ?></div>
                    <div class="enbombas-bulk-stat-label"><?php _e('Procesadas', 'en-bombas'); ?></div>
                </div>
                <div class="enbombas-bulk-stat">
                    <div class="enbombas-bulk-stat-value" id="enbombas-bulk-success"><?php echo esc_html($bulk_status['success'] ?? 0); ?></div>
                    <div class="enbombas-bulk-stat-label"><?php _e('Exitosas', 'en-bombas'); ?></div>
                </div>
                <div class="enbombas-bulk-stat">
                    <div class="enbombas-bulk-stat-value" id="enbombas-bulk-failed"><?php echo esc_html($bulk_status['failed'] ?? 0); ?></div>
                    <div class="enbombas-bulk-stat-label"><?php _e('Fallidas', 'en-bombas'); ?></div>
                </div>
                <div class="enbombas-bulk-stat">
                    <div class="enbombas-bulk-stat-value" id="enbombas-bulk-saved"><?php echo esc_html($bulk_status['total_saved_formatted'] ?? '0 B'); ?></div>
                    <div class="enbombas-bulk-stat-label"><?php _e('Ahorrado', 'en-bombas'); ?></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Info Cards -->
    <div class="enbombas-stats-grid">
        <div class="enbombas-stat-card">
            <div class="enb-icon-bg"><span class="enb-icon"><?php echo $icons['bolt']; ?></span></div>
            <div class="enbombas-stat-value"><?php echo esc_html($settings['compression_level'] === 'smart' ? 'IA' : ucfirst($settings['compression_level'])); ?></div>
            <div class="enbombas-stat-label"><?php _e('Nivel de Compresión', 'en-bombas'); ?></div>
        </div>
        <div class="enbombas-stat-card">
            <div class="enb-icon-bg"><span class="enb-icon"><?php echo $icons['image']; ?></span></div>
            <div class="enbombas-stat-value enb-status-<?php echo $settings['generate_webp'] ? 'on' : 'off'; ?>"><?php echo $settings['generate_webp'] ? __('Sí', 'en-bombas') : __('No', 'en-bombas'); ?></div>
            <div class="enbombas-stat-label"><?php _e('Generación WebP', 'en-bombas'); ?></div>
        </div>
        <div class="enbombas-stat-card">
            <div class="enb-icon-bg"><span class="enb-icon"><?php echo $icons['palette']; ?></span></div>
            <div class="enbombas-stat-value enb-status-<?php echo $settings['generate_avif'] ? 'on' : 'off'; ?>"><?php echo $settings['generate_avif'] ? __('Sí', 'en-bombas') : __('No', 'en-bombas'); ?></div>
            <div class="enbombas-stat-label"><?php _e('Generación AVIF', 'en-bombas'); ?></div>
        </div>
        <div class="enbombas-stat-card">
            <div class="enb-icon-bg"><span class="enb-icon"><?php echo $icons['save']; ?></span></div>
            <div class="enbombas-stat-value enb-status-<?php echo $settings['backup_enabled'] ? 'on' : 'off'; ?>"><?php echo $settings['backup_enabled'] ? __('Sí', 'en-bombas') : __('No', 'en-bombas'); ?></div>
            <div class="enbombas-stat-label"><?php _e('Respaldo Habilitado', 'en-bombas'); ?></div>
        </div>
    </div>

    <!-- Tips -->
    <div class="enbombas-card">
        <div class="enbombas-card-header">
            <h3 class="enbombas-card-title">
                <span class="enb-icon"><?php echo $icons['lightbulb']; ?></span>
                <?php _e('Tips de Optimización', 'en-bombas'); ?>
            </h3>
        </div>
        <div class="enbombas-tips-list">
            <p>
                <span class="enb-icon"><?php echo $icons['zap']; ?></span>
                <span><strong><?php _e('Modo Turbo:', 'en-bombas'); ?></strong> <?php _e('Activa el Modo Turbo en Configuración para procesar imágenes más rápido, parce.', 'en-bombas'); ?></span>
            </p>
            <p>
                <span class="enb-icon"><?php echo $icons['cpu']; ?></span>
                <span><strong><?php _e('Smart Bomb:', 'en-bombas'); ?></strong> <?php _e('Usa la compresión Smart Bomb para que la IA elija el mejor nivel para cada imagen.', 'en-bombas'); ?></span>
            </p>
            <p>
                <span class="enb-icon"><?php echo $icons['image']; ?></span>
                <span><strong><?php _e('Formatos Next-Gen:', 'en-bombas'); ?></strong> <?php _e('Activa la generación WebP/AVIF para ahorrar un 25-50% adicional.', 'en-bombas'); ?></span>
            </p>
            <p>
                <span class="enb-icon"><?php echo $icons['save']; ?></span>
                <span><strong><?php _e('Respaldos:', 'en-bombas'); ?></strong> <?php _e('Mantén los respaldos activos para poder restaurar las originales si lo necesitas.', 'en-bombas'); ?></span>
            </p>
        </div>
    </div>
</div>
</div>
