<?php
/**
 * Plugin Name: En Bombas – AI Image Optimizer
 * Plugin URI: https://ivanstudioweb.com
 * Description: AI-driven image optimization that makes your website go EN BOMBAS – extremely fast, light, and fully optimized automatically.
 * Version: 1.0.0
 * Author: Ivan Studio Web
 * Author URI: https://ivanstudioweb.com
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: en-bombas
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 8.0
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Plugin constants
define('ENBOMBAS_VERSION', '1.0.0');
define('ENBOMBAS_PLUGIN_FILE', __FILE__);
define('ENBOMBAS_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('ENBOMBAS_PLUGIN_URL', plugin_dir_url(__FILE__));
define('ENBOMBAS_PLUGIN_BASENAME', plugin_basename(__FILE__));

// Autoloader
spl_autoload_register(function ($class) {
    $prefix = 'EnBombas\\';
    $base_dir = ENBOMBAS_PLUGIN_DIR . 'inc/';

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }

    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    if (file_exists($file)) {
        require $file;
    }
});

// Initialize the plugin
function enbombas_init(): void {
    $plugin = \EnBombas\Core\Plugin::get_instance();
    $plugin->run();
}

// Activation hook
register_activation_hook(__FILE__, function () {
    \EnBombas\Core\Plugin::activate();
});

// Deactivation hook
register_deactivation_hook(__FILE__, function () {
    \EnBombas\Core\Plugin::deactivate();
});

// Boot the plugin
add_action('plugins_loaded', 'enbombas_init');



