/**
 * En Bombas Nitro - Admin JavaScript
 */
(function($) {
    'use strict';

    const EnBombasNitro = {
        /**
         * Initialize
         */
        init: function() {
            this.bindEvents();
            this.initTabs();
            this.initSliders();
            this.initRadioCards();
            this.updateHeartbeatUI();
        },

        /**
         * Bind events
         */
        bindEvents: function() {
            // Clear cache
            $('#enb-nitro-clear-cache').on('click', this.clearCache.bind(this));

            // Optimize database
            $('#enb-optimize-db').on('click', this.optimizeDatabase.bind(this));

            // Tab navigation
            $('.enbombas-nitro-tab, .enb-tab').on('click', this.switchTab.bind(this));
            
            // Also handle tab clicks on .enb-tabs container
            $('.enb-tabs, .enbombas-nitro-tabs').on('click', '.enb-tab, .enbombas-nitro-tab', this.switchTab.bind(this));

            // Heartbeat behavior change
            $('input[name="heartbeat_behavior"]').on('change', this.updateHeartbeatUI.bind(this));

            // Radio cards
            $('.enbombas-radio-card input[type="radio"]').on('change', this.handleRadioCardChange);

            // Slider value display
            $('input[type="range"]').on('input', this.updateSliderValue);

            // Switch changes - auto-save
            $(document).on('change', '.enb-switch input[type="checkbox"], .enbombas-toggle input[type="checkbox"]', this.handleSwitchChange.bind(this));
        },

        /**
         * Initialize tabs
         */
        initTabs: function() {
            // Check URL hash for initial tab
            const hash = window.location.hash.replace('#', '');
            if (hash && $(`.enbombas-nitro-tab[data-tab="${hash}"]`).length) {
                this.activateTab(hash);
            }
        },

        /**
         * Switch tab
         */
        switchTab: function(e) {
            const tab = $(e.currentTarget).data('tab');
            this.activateTab(tab);
            
            // Update URL hash without scrolling
            history.replaceState(null, null, '#' + tab);
        },

        /**
         * Activate tab
         */
        activateTab: function(tab) {
            // Update tab buttons
            $('.enbombas-nitro-tab, .enb-tab').removeClass('active enb-tab-active');
            $(`.enbombas-nitro-tab[data-tab="${tab}"], .enb-tab[data-tab="${tab}"]`).addClass('active enb-tab-active');

            // Update panels
            $('.enbombas-nitro-panel').removeClass('active');
            $(`.enbombas-nitro-panel[data-panel="${tab}"]`).addClass('active');
        },

        /**
         * Initialize sliders
         */
        initSliders: function() {
            $('input[type="range"]').each(function() {
                const $slider = $(this);
                const $value = $slider.siblings('.enbombas-slider-labels').find('.enbombas-slider-value');
                
                $value.text($slider.val() + 's');
            });
        },

        /**
         * Update slider value display
         */
        updateSliderValue: function() {
            const $slider = $(this);
            const $value = $slider.siblings('.enbombas-slider-labels').find('.enbombas-slider-value');
            
            $value.text($slider.val() + 's');
        },

        /**
         * Initialize radio cards
         */
        initRadioCards: function() {
            $('.enbombas-radio-card input[type="radio"]').each(function() {
                if ($(this).is(':checked')) {
                    $(this).closest('.enbombas-radio-card').addClass('active');
                }
            });
        },

        /**
         * Handle radio card change
         */
        handleRadioCardChange: function() {
            const $card = $(this).closest('.enbombas-radio-card');
            const $group = $card.closest('.enbombas-radio-cards');

            $group.find('.enbombas-radio-card').removeClass('active');
            $card.addClass('active');
        },

        /**
         * Handle switch change - auto-save via REST or AJAX
         */
        handleSwitchChange: function(e) {
            const $input = $(e.target);
            const name = $input.attr('name');
            const value = $input.is(':checked') ? '1' : '0';

            if (!name) {
                return;
            }

            // Use the setting name directly (RestAPI will check if it's a Nitro setting)
            const key = name;

            // Try REST first, fallback to AJAX
            if (typeof enbData !== 'undefined' && enbData.restUrl) {
                fetch(enbData.restUrl, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-WP-Nonce': enbData.nonce
                    },
                    body: JSON.stringify({ key: key, value: value })
                })
                .then(res => {
                    if (!res.ok) throw new Error('REST error');
                    return res.json();
                })
                .then(data => {
                    if (data.success) {
                        console.log('En Bombas setting updated:', key, value);
                        window.location.reload();
                    }
                })
                .catch(() => {
                    // Fallback to admin-ajax
                    return $.post(enbData.ajaxUrl, {
                        action: 'enbombas_update_setting',
                        key: key,
                        value: value,
                        nonce: enbData.ajaxNonce || enbData.nonce
                    });
                })
                .then(function(data) {
                    if (data && data.success) {
                        console.log('En Bombas setting updated (AJAX):', key, value);
                        window.location.reload();
                    }
                })
                .catch(err => {
                    console.error('En Bombas: Error updating setting', err);
                });
            } else if (typeof enbombasNitroAdmin !== 'undefined') {
                // Fallback to AJAX only
                $.post(enbombasNitroAdmin.ajaxUrl, {
                    action: 'enbombas_update_setting',
                    key: key,
                    value: value,
                    nonce: enbombasNitroAdmin.nonce
                })
                .done(function(data) {
                    if (data.success) {
                        console.log('En Bombas setting updated:', key, value);
                        window.location.reload();
                    }
                })
                .fail(function(err) {
                    console.error('En Bombas: Error updating setting', err);
                });
            }
        },

        /**
         * Update heartbeat UI based on behavior
         */
        updateHeartbeatUI: function() {
            const behavior = $('input[name="heartbeat_behavior"]:checked').val();
            const $frequencyGroup = $('#heartbeat-frequency-group');

            if (behavior === 'reduce') {
                $frequencyGroup.slideDown(200);
            } else {
                $frequencyGroup.slideUp(200);
            }
        },

        /**
         * Save settings
         */
        saveSettings: function(e) {
            e.preventDefault();

            const $button = $('#enb-nitro-save');
            const originalText = $button.html();

            $button.prop('disabled', true).html(
                '<span class="enb-icon enb-icon-spinner enb-spin"></span> ' +
                (typeof enbombasNitroAdmin !== 'undefined' ? enbombasNitroAdmin.strings.saving : 'Guardando...')
            );

            const formData = $('#enbombas-nitro-form').serialize();

            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: formData + '&action=enbombas_nitro_save',
                success: function(response) {
                    if (response.success) {
                        EnBombasNitro.showToast('success', response.data.message);
                    } else {
                        EnBombasNitro.showToast('error', response.data.message || 'Error al guardar');
                    }
                },
                error: function() {
                    EnBombasNitro.showToast('error', 'Error de conexión');
                },
                complete: function() {
                    $button.prop('disabled', false).html(originalText);
                }
            });
        },

        /**
         * Clear cache
         */
        clearCache: function(e) {
            e.preventDefault();

            const $button = $('#enb-nitro-clear-cache');
            const originalText = $button.html();

            $button.prop('disabled', true).html(
                '<span class="enb-icon enb-icon-spinner enb-spin"></span> ' +
                (typeof enbombasNitroAdmin !== 'undefined' ? enbombasNitroAdmin.strings.clearing : 'Limpiando...')
            );

            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'enbombas_nitro_clear_cache',
                    nonce: $('#enbombas_nonce').val()
                },
                success: function(response) {
                    if (response.success) {
                        EnBombasNitro.showToast('success', response.data.message);
                        // Update cache stats
                        $('#nitro-cache-files').text('0');
                        $('#nitro-cache-size').text('0 B');
                    } else {
                        EnBombasNitro.showToast('error', response.data.message || 'Error al limpiar caché');
                    }
                },
                error: function() {
                    EnBombasNitro.showToast('error', 'Error de conexión');
                },
                complete: function() {
                    $button.prop('disabled', false).html(originalText);
                }
            });
        },

        /**
         * Optimize database
         */
        optimizeDatabase: function(e) {
            e.preventDefault();

            const $button = $('#enb-optimize-db');
            const originalText = $button.html();

            $button.prop('disabled', true).html(
                '<span class="enb-icon enb-icon-spinner enb-spin"></span> ' +
                (typeof enbombasNitroAdmin !== 'undefined' ? enbombasNitroAdmin.strings.optimizing : 'Optimizando...')
            );

            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'enbombas_nitro_optimize_db',
                    nonce: $('#enbombas_nonce').val()
                },
                success: function(response) {
                    if (response.success) {
                        EnBombasNitro.showToast('success', response.data.message);
                        
                        // Update stats display
                        if (response.data.stats) {
                            EnBombasNitro.updateDatabaseStats(response.data.stats);
                        }

                        // Refresh page to show updated stats
                        setTimeout(function() {
                            location.reload();
                        }, 1500);
                    } else {
                        EnBombasNitro.showToast('error', response.data.message || 'Error al optimizar');
                    }
                },
                error: function() {
                    EnBombasNitro.showToast('error', 'Error de conexión');
                },
                complete: function() {
                    $button.prop('disabled', false).html(originalText);
                }
            });
        },

        /**
         * Update database stats display
         */
        updateDatabaseStats: function(stats) {
            // Update potential savings
            $('#nitro-db-potential').text('0');

            // Update individual stat values
            $('.enbombas-db-stat-value').text('0').removeClass('has-items');
        },

        /**
         * Show toast notification
         */
        showToast: function(type, message) {
            const $container = $('#enbombas-toast-container');
            
            const iconSvg = type === 'success' 
                ? '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path><polyline points="22 4 12 14.01 9 11.01"></polyline></svg>'
                : '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg>';

            const $toast = $(`
                <div class="enbombas-toast enbombas-toast-${type}">
                    <span class="enbombas-toast-icon">${iconSvg}</span>
                    <span class="enbombas-toast-message">${message}</span>
                    <button class="enbombas-toast-close">&times;</button>
                </div>
            `);

            $container.append($toast);

            // Animate in
            setTimeout(function() {
                $toast.addClass('show');
            }, 10);

            // Close button
            $toast.find('.enbombas-toast-close').on('click', function() {
                $toast.removeClass('show');
                setTimeout(function() {
                    $toast.remove();
                }, 300);
            });

            // Auto remove after 5 seconds
            setTimeout(function() {
                $toast.removeClass('show');
                setTimeout(function() {
                    $toast.remove();
                }, 300);
            }, 5000);
        },

        /**
         * Refresh stats
         */
        refreshStats: function() {
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'enbombas_nitro_get_stats',
                    nonce: $('#enbombas_nonce').val()
                },
                success: function(response) {
                    if (response.success) {
                        const stats = response.data;
                        
                        // Update cache stats
                        if (stats.cache) {
                            $('#nitro-cache-files').text(stats.cache.total_files);
                            $('#nitro-cache-size').text(stats.cache.total_size_formatted);
                        }

                        // Update database stats
                        if (stats.database) {
                            $('#nitro-db-size').text(stats.database.db_size_formatted);
                            $('#nitro-db-potential').text(stats.database.potential_savings);
                        }
                    }
                }
            });
        }
    };

    // Initialize on document ready
    $(document).ready(function() {
        EnBombasNitro.init();
    });

    // Expose to global scope
    window.EnBombasNitro = EnBombasNitro;

})(jQuery);


